### 2B_FL Proteins PD50

setwd('~/Documents/Research_Projects/LEA_CAHS_Oligomerization')

#call in packages
library(tidyverse)
library(dplyr)
library(purrr)
library(broom)
library(stringr)
library(ggplot2)
library(plotly)
library(readxl)
library(RColorBrewer)
library(patchwork)
library(grid)
library(ggsignif)
library(scales)

#FL Proteins
PD50_FL <- read_xlsx('Figure_1_PD50.xlsx', sheet = 'FL Proteins')
PD50_FL$Additive <- factor(PD50_FL$Additive, levels = c('CAHS D', 'HeLEA68614','AvLEA1C', 'BSA', 'AtLEA3-3', 'AavLEA1', 'AtLEA4-2', 'Trehalose','Sucrose'))
#make graph 
FL <-ggplot(data = PD50_FL, aes(x = Additive, y = PD50*100, fill = Additive))+
  geom_col(position = position_dodge(width = .9), color = 'black', size = 0.25)+
  theme_bw()+
  theme(
    plot.title = element_text(hjust = .5, size = 8),
    axis.title.y = element_text(size =8),
    axis.text.y = element_text(size =8),
    axis.title.x = element_text(size = 8),
    axis.text.x = element_text(size =8, angle = 45, hjust = 1),
    legend.text=element_text(size=14),
    legend.position = 'none', aspect.ratio = 1,
    legend.title = element_blank(),
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  labs(x = '',
       y = expression('PD50 (mM)'),
       title = '')+
  scale_fill_manual(values = c('#797979','#9337FF','#918F00','#CD91CD','#6BA5C8','#5ABA56','#CD5B45','#0433FF','#FF9200'))+
  geom_errorbar(aes(ymin = PD50 - STD, ymax = PD50 + STD), width = .2, position = position_dodge(.9))+
  scale_y_continuous(trans = 'log10', limits = c(1,10000),
                     breaks = c(1,10,100,1000,10000),
                     labels = c(0.01,0.1,1,10,100))+
  geom_errorbar(aes(ymin = PD50*100 - STD*100, ymax = PD50*100 + STD*100), width = .2, position = position_dodge(.9))


### 2C_FL Proteins synergy with Trehalose

#Set working directory----
setwd('~/Downloads/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('Figure_1_LEA_Synergy.xlsx', sheet = 'Trehalose')
#Change the factor order
data$Sample <- factor(data$Sample,levels = c('AtLEA3-3',
                                             'AavLEA1',
                                             'HeLEA68614',
                                             'AvLEA1C',
                                             'AtLEA4-2',
                                             'CAHS D',
                                             'BSA'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Sample, y = Protect_add, fill = interaction(Sample, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Full-length Protein', y = '',
       title = 'Trehalose: Protein')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('skyblue1', 'seagreen1', 'mediumpurple1',  'yellow1', 'coral1', 'azure1', 'thistle1',
                             'skyblue3',   'seagreen3', 'mediumpurple3', 'yellow3', 'coral3', 'azure4', 'thistle3'))+
  #add significane values
  geom_signif(
    y_position = c(63, 61, 65,63, 51, 90, 58),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75,5.75, 6.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25, 6.25, 7.25),
    annotation = c("***", "***", "***",'NS',"NS","***", "NS"),
    tip_length = 0, color = "black")



### 2D_FL Protein synergy with sucrose

#Set working directory----
setwd('~/Downloads/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('Figure_1_LEA_Synergy.xlsx', sheet = 'Sucrose')
#Change the factor order
data$Sample <- factor(data$Sample,levels = c('AtLEA3-3',
                                             'AavLEA1',
                                             'HeLEA68614',
                                             'AvLEA1C',
                                             'AtLEA4-2',
                                             'CAHS D',
                                             'BSA'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Sample, y = Protect_add, fill = interaction(Sample, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Full-length Protein',
       y = '%Protection',
       title = 'Sucrose: Protein')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('skyblue1', 'seagreen1', 'mediumpurple1',  'yellow1', 'coral1', 'azure1', 'thistle1',
                             'skyblue3',   'seagreen3', 'mediumpurple3', 'yellow3', 'coral3', 'azure4', 'thistle3'))+
  #add significane values
  geom_signif(
    y_position = c(63, 50, 50,63, 73, 72, 55),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75,5.75, 6.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25, 6.25, 7.25),
    annotation = c("***", "**", "NS",'NS',"***","***", "NS"),
    tip_length = 0, color = "black")



### 2E_Trehalose vs Sucrose synergy

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('Figure_1J_Synergy_with_Sugars.xlsx')
#Change the factor order
data$prot <- factor(data$prot,levels = c('AtLEA3-3',
                                         'AavLEA1',
                                         'HeLEA68614',
                                         'AvLEA1C',
                                         'AtLEA4-2',
                                         'CAHS D',
                                         'BSA'))
#build ggplot environment
ggplot(data = data, aes(x = `%synergy_tre`, y = `%synergy_suc`, fill = prot))+
  geom_point(size = 6.5, shape = 21, color = 'black')+
  theme_bw()+
  theme(panel.grid = element_blank(),
        plot.title = element_text(hjust = 0.05, size = 14, vjust = -8),
        axis.title = element_text(size =14),
        axis.text.y = element_text(size =12),
        axis.text.x = element_text(size =12),
        legend.text=element_text(size=14), 
        legend.position = 'none', aspect.ratio = 1,
        panel.border = element_rect(colour = "black", fill=NA, size=1))+
  xlim(-10,50)+
  ylim(-10,50)+
  scale_color_manual(values = c(
    'skyblue3', 'seagreen3', 'mediumpurple3', 'yellow3', 'coral3', 'azure4', 'thistle3'))+
  geom_abline(linetype = 'dashed',
              linewidth = 1)+
  geom_errorbar(aes(ymin = `%synergy_suc` - `%synergy_suc_err`,
                    ymax = `%synergy_suc` + `%synergy_suc_err`),
                width = 1, position = position_dodge(.9))+
  geom_errorbarh(aes(xmin = `%synergy_tre` - `%synergy_tre_err`,
                     xmax = `%synergy_tre` + `%synergy_tre_err`),
                 height = 1, position = position_dodge(.9))+
  labs(
    x = 'Synergy with Trehalose (%)',
    y = 'Synergy with Sucrose (%)'
  )

